<?php

//
//  Custom Child Theme Functions
//

// I've included a "commented out" sample function below that'll add a home link to your menu
// More ideas can be found on "A Guide To Customizing The Thematic Theme Framework" 
// http://themeshaper.com/thematic-for-wordpress/guide-customizing-thematic-theme-framework/

// Adds a home link to your menu
// http://codex.wordpress.org/Template_Tags/wp_page_menu
//function childtheme_menu_args($args) {
//    $args = array(
//        'show_home' => 'Home',
//        'sort_column' => 'menu_order',
//        'menu_class' => 'menu',
//        'echo' => true
//    );
//	return $args;
//}
//add_filter('wp_page_menu_args','childtheme_menu_args');

// Unleash the power of Thematic's dynamic classes
// 
// define('THEMATIC_COMPATIBLE_BODY_CLASS', true);
// define('THEMATIC_COMPATIBLE_POST_CLASS', true);

// Unleash the power of Thematic's comment form
//
// define('THEMATIC_COMPATIBLE_COMMENT_FORM', true);

// Unleash the power of Thematic's feed link functions
//
// define('THEMATIC_COMPATIBLE_FEEDLINKS', true);

add_theme_support( 'post-thumbnails' );

function child_add_menuclass($ulclass) {
	return preg_replace('/<ul>/', '<ul id="nav" class="sf-menu sf-vertical">', $ulclass, 1);
}
add_filter('wp_page_menu','child_add_menuclass');

function child_aboveheader() {

	echo '<div id="hero">';

	if ( has_post_thumbnail() ) {
		the_post_thumbnail();
	} else {
		echo '<img src="' . get_bloginfo('stylesheet_directory'). '/images/header-find-contact.jpg" width="960" height="275" alt"" />';
	}
	
	echo '<div id="heroname">Dr. Dian J. Ginsberg &bull; Dr. Lauren U. Ta</div>';
	
	echo '<p>Healthcare for Women of All Ages and All Stages</p>';
	
	echo '</div>';

}
add_filter('thematic_aboveheader', 'child_aboveheader');

function child_header() {

	echo '<div id="headersidebar">';
	
	echo '<a href="#" target="_blank"><img style="padding-bottom: 40px;" src="' . get_bloginfo('stylesheet_directory'). '/images/sidebar-logo-specialty-healthcare-wellness.png" width="250" height="115" alt"" /></a>';

	echo '</div>';

}
add_filter('thematic_header','child_header',50);

function child_abovefooter() {

	echo '<div id="containercontact">';
	
	echo '<p>Call to schedule your appointment: 281-220-2069</p>';
	
	echo '</div>';

}
add_filter('thematic_abovefooter', 'child_abovefooter');

?>